# include <document.h>
# include <gemdefs.h>

# define PAG_UP 0
# define PAG_DN 1
# define ROW_UP 2
# define ROW_DN 3
# define PAG_LF 4
# define PAG_RT 5
# define COL_LF 6
# define COL_RT 7

int xlines;
int cur_line, cur_col;

do_arrows(operation,whand,vw)
int operation, whand, vw; {
	
		int x, y, w, h, wlines, wcols;
		extern cur_line, cur_col, gl_wchar, gl_hchar, xlines;
		int vertical, horizontal;
		wind_get (whand, WF_WORKXYWH, &x, &y, &w, &h);
		
		wlines = h / gl_hchar;
		wcols = w / gl_wchar;
		
		switch(operation)(
			case PAG_UP:
				cur_line -= wlines;
				if( cur_line < 0 )
					cur_line = 0;
				break;
			case PAG_DN:
				cur_line += wlines;
				if (cur_line > NLINES - wlines )
					cur_line = NLINES - wlines;
				break;
			case ROW_UP:
				cur_line-;
				if ( cur_line < 0 )
					cur_line = 0;
				break;
			case ROW_DN:
				cur_line++;
				if( cur_line > NLINES - wlines )
					cur_line = NLINES - wlines;
				break;
			case PAG_LF:
				cur_col -= wcols;
				if( cur_col < 0 )
					cur_col = 0;
				break;
			case PAG_RT:
				cur_col += wcols;
				if( cur_col  > NCHARS - wcols )
					cur_col = NCHARS - wcols;
				break;
			case COL_LF:
				cur_col-;
				if( cur_col < 0 )
					cur_col = 0;
				break;
			case COL_RT:
				cur_col++;
				if ( cur_col  > NCHARS - wcols )
					cur_col = NCHARS - wcols;
				break;
			}
		slide_pos( wlines, xlines, cur_line, &vertical );
		slide_pos( wcols, NCHARS, cur_col, &horizontal );
		wind_set(whand, WF_VSLIDE, vertical, 0, 0, 0 );
		wind_set(whand, WF_HSLIDE, horizontal, 0, 0, 0 );
}